/**
 * Created by lei.wang_1 on 2016/8/23.
 */
appModule.directive("imageAdapter", ["$translate", "utils", function (translate, utils) {
    return {
        restrict: "A",
        link: function ($scope, $element) {
            $element.on('load', function (e) {
                var natureWidth, natureHeight, parentWidth, parentHeight, width, height, marginLeft = 0, marginTop = 0;
                natureWidth = this.naturalWidth;
                natureHeight = this.naturalHeight;
                parentWidth = $(this).parent().width();
                parentHeight = $(this).parent().height();
                if (natureWidth / natureHeight < parentWidth / parentHeight) {
                    width = parentWidth;
                    height = natureHeight * (parentWidth / natureWidth);
                    marginTop = 0 - (height - parentHeight) / 2;
                } else {
                    height = parentHeight;
                    width = natureWidth * (parentHeight / natureHeight);
                    marginLeft = 0 - (width - parentWidth) / 2;
                }

                $(this).css({
                    'width': width,
                    'height': height,
                    'left': marginLeft,
                    'top': marginTop,
                    'position':'absolute'
                });
            })
        }
    }
}]);